/*
 * Decompiled with CFR 0.152.
 */
package dev.doctor4t.wathe.mixin.compat.sodium;

import com.llamalad7.mixinextras.injector.ModifyExpressionValue;
import com.llamalad7.mixinextras.sugar.Local;
import dev.doctor4t.wathe.client.WatheClient;
import dev.doctor4t.wathe.compat.SodiumShaderInterface;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import net.caffeinemc.mods.sodium.client.gl.buffer.GlBuffer;
import net.caffeinemc.mods.sodium.client.gl.buffer.GlBufferUsage;
import net.caffeinemc.mods.sodium.client.gl.buffer.GlMutableBuffer;
import net.caffeinemc.mods.sodium.client.gl.device.CommandList;
import net.caffeinemc.mods.sodium.client.gl.device.MultiDrawBatch;
import net.caffeinemc.mods.sodium.client.render.chunk.ChunkRenderMatrices;
import net.caffeinemc.mods.sodium.client.render.chunk.DefaultChunkRenderer;
import net.caffeinemc.mods.sodium.client.render.chunk.LocalSectionIndex;
import net.caffeinemc.mods.sodium.client.render.chunk.data.SectionRenderDataStorage;
import net.caffeinemc.mods.sodium.client.render.chunk.lists.ChunkRenderList;
import net.caffeinemc.mods.sodium.client.render.chunk.lists.ChunkRenderListIterable;
import net.caffeinemc.mods.sodium.client.render.chunk.region.RenderRegion;
import net.caffeinemc.mods.sodium.client.render.chunk.shader.ChunkShaderInterface;
import net.caffeinemc.mods.sodium.client.render.chunk.terrain.TerrainRenderPass;
import net.caffeinemc.mods.sodium.client.render.viewport.CameraTransform;
import net.minecraft.class_2338;
import net.minecraft.class_310;
import net.minecraft.class_4076;
import org.lwjgl.system.MemoryUtil;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={DefaultChunkRenderer.class})
public abstract class DefaultChunkRendererMixin {
    @Unique
    private static ByteBuffer wathe_buffer = MemoryUtil.memAlloc((int)4096);
    @Unique
    private static GlMutableBuffer glBuffer;

    @ModifyExpressionValue(method={"render(Lnet/caffeinemc/mods/sodium/client/render/chunk/ChunkRenderMatrices;Lnet/caffeinemc/mods/sodium/client/gl/device/CommandList;Lnet/caffeinemc/mods/sodium/client/render/chunk/lists/ChunkRenderListIterable;Lnet/caffeinemc/mods/sodium/client/render/chunk/terrain/TerrainRenderPass;Lnet/caffeinemc/mods/sodium/client/render/viewport/CameraTransform;)V"}, at={@At(value="FIELD", target="Lnet/caffeinemc/mods/sodium/client/gui/SodiumGameOptions$PerformanceSettings;useBlockFaceCulling:Z")}, remap=false)
    private boolean wathe$disable_culling(boolean original) {
        if (WatheClient.isTrainMoving()) {
            return false;
        }
        return original;
    }

    @Inject(method={"render(Lnet/caffeinemc/mods/sodium/client/render/chunk/ChunkRenderMatrices;Lnet/caffeinemc/mods/sodium/client/gl/device/CommandList;Lnet/caffeinemc/mods/sodium/client/render/chunk/lists/ChunkRenderListIterable;Lnet/caffeinemc/mods/sodium/client/render/chunk/terrain/TerrainRenderPass;Lnet/caffeinemc/mods/sodium/client/render/viewport/CameraTransform;)V"}, at={@At(value="INVOKE", target="Lnet/caffeinemc/mods/sodium/client/render/chunk/DefaultChunkRenderer;executeDrawBatch(Lnet/caffeinemc/mods/sodium/client/gl/device/CommandList;Lnet/caffeinemc/mods/sodium/client/gl/tessellation/GlTessellation;Lnet/caffeinemc/mods/sodium/client/gl/device/MultiDrawBatch;)V")}, remap=false)
    private void modifyChunkRenderBefore(ChunkRenderMatrices matrices, CommandList commandList, ChunkRenderListIterable renderLists, TerrainRenderPass renderPass, CameraTransform camera, CallbackInfo ci, @Local(ordinal=0) ChunkShaderInterface shader, @Local(ordinal=0) RenderRegion region) {
        glBuffer = commandList.createMutableBuffer();
        commandList.uploadData(glBuffer, wathe_buffer, GlBufferUsage.STREAM_DRAW);
        ((SodiumShaderInterface)shader).wathe$set(glBuffer);
    }

    @Inject(method={"render(Lnet/caffeinemc/mods/sodium/client/render/chunk/ChunkRenderMatrices;Lnet/caffeinemc/mods/sodium/client/gl/device/CommandList;Lnet/caffeinemc/mods/sodium/client/render/chunk/lists/ChunkRenderListIterable;Lnet/caffeinemc/mods/sodium/client/render/chunk/terrain/TerrainRenderPass;Lnet/caffeinemc/mods/sodium/client/render/viewport/CameraTransform;)V"}, at={@At(value="INVOKE", target="Lnet/caffeinemc/mods/sodium/client/render/chunk/DefaultChunkRenderer;executeDrawBatch(Lnet/caffeinemc/mods/sodium/client/gl/device/CommandList;Lnet/caffeinemc/mods/sodium/client/gl/tessellation/GlTessellation;Lnet/caffeinemc/mods/sodium/client/gl/device/MultiDrawBatch;)V", shift=At.Shift.AFTER)}, remap=false)
    private void modifyChunkRenderAfter(ChunkRenderMatrices matrices, CommandList commandList, ChunkRenderListIterable renderLists, TerrainRenderPass renderPass, CameraTransform camera, CallbackInfo ci) {
        MemoryUtil.memFree((Buffer)wathe_buffer);
        commandList.deleteBuffer((GlBuffer)glBuffer);
        wathe_buffer = null;
    }

    @Inject(method={"fillCommandBuffer(Lnet/caffeinemc/mods/sodium/client/gl/device/MultiDrawBatch;Lnet/caffeinemc/mods/sodium/client/render/chunk/region/RenderRegion;Lnet/caffeinemc/mods/sodium/client/render/chunk/data/SectionRenderDataStorage;Lnet/caffeinemc/mods/sodium/client/render/chunk/lists/ChunkRenderList;Lnet/caffeinemc/mods/sodium/client/render/viewport/CameraTransform;Lnet/caffeinemc/mods/sodium/client/render/chunk/terrain/TerrainRenderPass;Z)V"}, at={@At(value="INVOKE", target="Lnet/caffeinemc/mods/sodium/client/render/chunk/data/SectionRenderDataUnsafe;getSliceMask(J)I")}, remap=false)
    private static void wathe$offsetScenery(MultiDrawBatch batch, RenderRegion region, SectionRenderDataStorage renderDataStorage, ChunkRenderList renderList, CameraTransform camera, TerrainRenderPass pass, boolean useBlockFaceCulling, CallbackInfo ci, @Local(name={"sectionIndex"}) int sectionIndex) {
        if (wathe_buffer == null) {
            wathe_buffer = MemoryUtil.memAlloc((int)4096);
        }
        wathe_buffer.putFloat(sectionIndex * 16, 0.0f);
        wathe_buffer.putFloat(sectionIndex * 16 + 4, 0.0f);
        wathe_buffer.putFloat(sectionIndex * 16 + 8, 0.0f);
        if (WatheClient.isTrainMoving()) {
            float trainSpeed = WatheClient.getTrainSpeed();
            int chunkSize = 16;
            int tileWidth = 15 * chunkSize;
            int height = 116;
            int tileLength = 32 * chunkSize;
            int tileSize = tileLength * 3;
            float time = WatheClient.trainComponent.getTime() + class_310.method_1551().method_60646().method_60637(true);
            class_2338 blockPos = new class_2338(region.getOriginX() + LocalSectionIndex.unpackX((int)sectionIndex) * 16, region.getOriginY() + LocalSectionIndex.unpackY((int)sectionIndex) * 16, region.getOriginZ() + LocalSectionIndex.unpackZ((int)sectionIndex) * 16);
            boolean trainSection = class_4076.method_18675((int)blockPos.method_10264()) >= 4;
            float v1 = (float)((double)blockPos.method_10263() - (double)camera.fracX);
            float v2 = (float)((double)blockPos.method_10264() - (double)camera.fracY);
            float v3 = (float)((double)blockPos.method_10260() - (double)camera.fracZ);
            int zSection = blockPos.method_10260() / chunkSize - class_4076.method_18675((int)camera.intZ);
            float finalX = v1;
            float finalY = v2;
            float finalZ = v3;
            if (zSection <= -8) {
                finalX = (v1 - (float)tileLength + time / 73.8f * trainSpeed) % (float)tileSize - (float)tileSize / 2.0f;
                finalY = v2 + (float)height;
                finalZ = v3 + (float)tileWidth;
            } else if (zSection >= 8) {
                finalX = (v1 + (float)tileLength + time / 73.8f * trainSpeed) % (float)tileSize - (float)tileSize / 2.0f;
                finalY = v2 + (float)height;
                finalZ = v3 - (float)tileWidth;
            } else if (!trainSection) {
                finalX = (v1 + time / 73.8f * trainSpeed) % (float)tileSize - (float)tileSize / 2.0f;
                finalY = v2 + (float)height;
                finalZ = v3;
            }
            finalX = (float)blockPos.method_10263() - finalX - camera.fracX;
            finalY = (float)blockPos.method_10264() - finalY - camera.fracY;
            finalZ = (float)blockPos.method_10260() - finalZ - camera.fracZ;
            wathe_buffer.putFloat(sectionIndex * 16, -finalX);
            wathe_buffer.putFloat(sectionIndex * 16 + 4, -finalY);
            wathe_buffer.putFloat(sectionIndex * 16 + 8, -finalZ);
        }
    }
}

